var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import KloudPlaylistLibrary from '#models/kloud_playlist_library';
import ApiResponseService from '#services/api_response_service';
import { addSongToPlaylistRequestParams, createNewPlaylistRequestParams, editPlaylistNameRequestParams, } from '#validators/user_library';
import { inject } from '@adonisjs/core';
import KloudPlaylistLibraryItem from '#models/kloud_playlist_library_item';
import { validate as uuidValidate } from 'uuid';
import db from '@adonisjs/lucid/services/db';
let UserPlaylistLibrariesController = class UserPlaylistLibrariesController {
    apiResponseService;
    constructor(apiResponseService) {
        this.apiResponseService = apiResponseService;
    }
    async fetchPlaylistLibrary({ auth }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const allPlaylist = await KloudPlaylistLibrary.query().where('user_id', userToken.id);
            return this.apiResponseService.apiSuccessResponse(allPlaylist, 'Playlist loaded successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserPlaylistLibrariesController/fetchPlaylistLibrary');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async createNewPlaylist({ request, auth }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const payload = await createNewPlaylistRequestParams.validate(request.all());
            const doPlaylistExist = await KloudPlaylistLibrary.query()
                .where('playlist_name', payload.playlist_name)
                .andWhere('user_id', userToken.id)
                .first();
            if (doPlaylistExist) {
                return this.apiResponseService.apiSuccessResponse(409, 'Playlist with same name already exists in library.');
            }
            const newPlaylist = new KloudPlaylistLibrary();
            newPlaylist.user_id = userToken.id;
            newPlaylist.playlist_name = payload.playlist_name;
            newPlaylist.total_items = 0;
            await newPlaylist.save();
            const allPlaylist = await KloudPlaylistLibrary.query().where('user_id', userToken.id);
            return this.apiResponseService.apiSuccessResponse(allPlaylist, 'Playlist created successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserPlaylistLibrariesController/createNewPlaylist');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async updatePlaylist({ request, auth }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const payload = await editPlaylistNameRequestParams.validate(request.all());
            const doPlaylistExist = await KloudPlaylistLibrary.query()
                .where('id', payload.playlist_id)
                .andWhere('user_id', userToken.id)
                .first();
            if (doPlaylistExist === null) {
                return this.apiResponseService.apiErrorResponse(404, 'Playlist not found');
            }
            const doPlaylistNameExist = await KloudPlaylistLibrary.query()
                .where('playlist_name', payload.playlist_name)
                .andWhere('user_id', userToken.id)
                .andWhere('id', '!=', payload.playlist_id)
                .first();
            if (doPlaylistNameExist) {
                return this.apiResponseService.apiSuccessResponse(409, 'Playlist with same name already exists in library.');
            }
            doPlaylistExist.playlist_name = payload.playlist_name;
            doPlaylistExist.save();
            return this.apiResponseService.apiSuccessResponse(doPlaylistExist, 'Playlist updated successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserPlaylistLibrariesController/updatePlaylist');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async deletePlaylist({ params }) {
        try {
            if (uuidValidate(params.playlistId) === false) {
                return this.apiResponseService.apiErrorResponse(400, 'Playlist id is required');
            }
            const doPlaylistExist = await KloudPlaylistLibrary.findBy('id', params.playlistId);
            if (!doPlaylistExist) {
                return this.apiResponseService.apiErrorResponse(404, 'Playlist not found');
            }
            await doPlaylistExist.delete();
            return this.apiResponseService.apiSuccessResponse('', 'Playlist deleted successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserPlaylistLibrariesController/deletePlaylist');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async fetchPlaylistItemsByPlaylistId({ params }) {
        try {
            if (uuidValidate(params.playlistId) === false) {
                return this.apiResponseService.apiErrorResponse(400, 'Playlist id is required');
            }
            const allPlaylistItems = await KloudPlaylistLibraryItem.query().where('playlist_id', params.playlistId);
            return this.apiResponseService.apiSuccessResponse(allPlaylistItems, 'Playlist items loaded successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserPlaylistLibrariesController/fetchPlaylistItemsByPlaylistId');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async addSongToPlaylist({ request }) {
        try {
            const payload = await addSongToPlaylistRequestParams.validate(request.all());
            const doPlaylistItemExist = await KloudPlaylistLibraryItem.query()
                .where('playlist_id', payload.playlist_id)
                .where('song_id', payload.song_id)
                .first();
            if (doPlaylistItemExist) {
                return this.apiResponseService.apiSuccessResponse(409, 'Song already exists in playlist.');
            }
            await db.transaction(async (trx) => {
                try {
                    const doPlaylistExist = await KloudPlaylistLibrary.findBy('id', payload.playlist_id);
                    if (doPlaylistExist === null) {
                        return this.apiResponseService.apiErrorResponse(404, 'Playlist does not exist.');
                    }
                    const playlistItem = new KloudPlaylistLibraryItem();
                    playlistItem.playlist_id = payload.playlist_id;
                    playlistItem.song_id = payload.song_id;
                    playlistItem.song_name = payload.song_name;
                    playlistItem.artist = payload.artist;
                    playlistItem.thumbnail = JSON.stringify(request.input('thumbnails'));
                    playlistItem.useTransaction(trx);
                    await playlistItem.save();
                    doPlaylistExist.total_items = doPlaylistExist.total_items + 1;
                    doPlaylistExist.useTransaction(trx);
                    await doPlaylistExist.save();
                    return this.apiResponseService.apiSuccessResponse('', 'Song added to playlist successfully');
                }
                catch (error) {
                    logError(error.message, 'KloudaaClient/UserPlaylistLibrariesController/addSongToPlaylist');
                    console.log(error.message);
                    return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
                }
            });
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserPlaylistLibrariesController/addSongToPlaylist');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async removeSongFromPlaylist({ params }) {
        try {
            if (uuidValidate(params.playlistItemId) === false) {
                return this.apiResponseService.apiErrorResponse(400, 'Playlist Item id is required');
            }
            await db.transaction(async (trx) => {
                try {
                    const playlistItem = await KloudPlaylistLibraryItem.query()
                        .where('playlist_item_id', params.playlistItemId)
                        .first();
                    if (playlistItem === null) {
                        return this.apiResponseService.apiErrorResponse(404, 'Song does not exist in playlist.');
                    }
                    const doPlaylistExist = await KloudPlaylistLibrary.findBy('id', playlistItem.playlist_id);
                    if (doPlaylistExist === null) {
                        return this.apiResponseService.apiErrorResponse(404, 'Playlist does not exist.');
                    }
                    playlistItem.useTransaction(trx);
                    await playlistItem.delete();
                    doPlaylistExist.total_items = doPlaylistExist.total_items - 1;
                    doPlaylistExist.useTransaction(trx);
                    await doPlaylistExist.save();
                    return this.apiResponseService.apiSuccessResponse('', 'Song removed from playlist successfully');
                }
                catch (error) {
                    logError(error.message, 'KloudaaClient/UserPlaylistLibrariesController/removeSongFromPlaylist');
                    console.log(error.message);
                    return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
                }
            });
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserPlaylistLibrariesController/removeSongFromPlaylist');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
};
UserPlaylistLibrariesController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService])
], UserPlaylistLibrariesController);
export default UserPlaylistLibrariesController;
//# sourceMappingURL=user_playlist_libraries_controller.js.map