var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import KloudAppSetting from '#models/kloud_app_setting';
import KloudUser from '#models/kloud_user';
import KloudUserSetting from '#models/kloud_user_setting';
import ApiResponseService from '#services/api_response_service';
import { completeProfileRequestParams } from '#validators/user_auth';
import { inject } from '@adonisjs/core';
import db from '@adonisjs/lucid/services/db';
let UserProfilesController = class UserProfilesController {
    apiResponseService;
    constructor(apiResponseService) {
        this.apiResponseService = apiResponseService;
    }
    async completeProfile({ auth, request }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const payload = await completeProfileRequestParams.validate(request.all());
            const getUserDBRow = await KloudUser.findBy('id', userToken.id);
            if (getUserDBRow) {
                await db.transaction(async (trx) => {
                    try {
                        getUserDBRow.gender = payload.gender;
                        getUserDBRow.country = payload.country_code.toUpperCase();
                        getUserDBRow.useTransaction(trx);
                        await getUserDBRow.save();
                        const getSetting = await KloudAppSetting.findBy('slug', 'SETTING_COUNTRY');
                        const getUserSetting = await KloudUserSetting.query()
                            .where('user_id', userToken.id)
                            .andWhere('kloudAppSettingId', getSetting.id)
                            .first();
                        if (getUserSetting) {
                            getUserSetting.setting_value = {
                                value: payload.country_code.toUpperCase(),
                            };
                            getUserSetting.useTransaction(trx);
                            await getUserSetting.save();
                        }
                        trx.commit();
                        return this.apiResponseService.apiSuccessResponse(null, 'Profile updated successfully');
                    }
                    catch (error) {
                        trx.rollback();
                        logError(error.message, 'KloudaaClient/UserProfilesController/completeProfile');
                        console.log(error.message);
                        return this.apiResponseService.apiErrorResponse(500, 'Server Error');
                    }
                });
            }
            else {
                throw Error('User or setting not found');
            }
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserProfilesController/completeProfile');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async fetchUserSetting({ auth }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const settingList = await KloudAppSetting.query()
                .orderBy('setting_key', 'asc')
                .preload('userSetting', (user) => {
                user.where('user_id', userToken.id);
            });
            return this.apiResponseService.apiSuccessResponse(settingList, 'Seting Loaded successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserProfilesController/completeProfile');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
};
UserProfilesController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService])
], UserProfilesController);
export default UserProfilesController;
//# sourceMappingURL=user_profiles_controller.js.map