import app from '@adonisjs/core/services/app';
import log from 'log-to-file';
export async function logError(errorMessage, controllerFunction) {
    const logData = {
        msg: errorMessage,
        type: 'Error',
        controller: controllerFunction,
    };
    await log(JSON.stringify(logData), app.tmpPath('log/error.log'), '\r\n');
}
export async function logInfo(errorMessage, controllerFunction) {
    const logData = {
        msg: errorMessage,
        type: 'Error',
        controller: controllerFunction,
    };
    await log(JSON.stringify(logData), app.tmpPath('log/info.log'), '\r\n');
}
//# sourceMappingURL=log_helpers.js.map