import { AlbumDetailed, AlbumFull, } from '#services/YoutubeAPI/@types/types';
import checkType from '#services/YoutubeAPI/utils/check_type';
import { isArtist } from '#services/YoutubeAPI/utils/filters';
import { traverse, traverseList, traverseString } from '#services/YoutubeAPI/utils/traverse';
import SongParser from '#services/YoutubeAPI/parsers/song_parser';
export default class AlbumParser {
    static parse(data, albumId) {
        const albumBasic = {
            albumId,
            name: traverseString(data, 'header', 'title', 'text'),
        };
        const artistData = traverse(data, 'header', 'subtitle', 'runs');
        console.log(artistData.find(isArtist));
        const artistBasic = {
            artistId: traverseString(artistData.find(isArtist), 'browseId') || null,
            name: traverseString(artistData.find(isArtist), 'text'),
        };
        const thumbnails = traverseList(data, 'header', 'thumbnails');
        return checkType({
            type: 'ALBUM',
            ...albumBasic,
            playlistId: traverseString(data, 'buttonRenderer', 'playlistId'),
            artist: artistBasic,
            year: AlbumParser.processYear(traverseList(data, 'header', 'subtitle', 'text').at(-1)),
            thumbnails,
            songs: traverseList(data, 'musicResponsiveListItemRenderer').map((item) => SongParser.parseAlbumSong(item, artistBasic, albumBasic, thumbnails)),
        }, AlbumFull);
    }
    static parseSearchResult(item) {
        const columns = traverseList(item, 'flexColumns', 'runs').flat();
        const title = columns[0];
        const artist = columns.find(isArtist) || columns[3];
        const playlistId = traverseString(item, 'overlay', 'playlistId') ||
            traverseString(item, 'thumbnailOverlay', 'playlistId');
        return checkType({
            type: 'ALBUM',
            albumId: traverseList(item, 'browseId').at(-1),
            playlistId,
            artist: {
                name: traverseString(artist, 'text'),
                artistId: traverseString(artist, 'browseId') || null,
            },
            year: AlbumParser.processYear(columns.at(-1)?.text),
            name: traverseString(title, 'text'),
            thumbnails: traverseList(item, 'thumbnails'),
        }, AlbumDetailed);
    }
    static parseArtistAlbum(item, artistBasic) {
        return checkType({
            type: 'ALBUM',
            albumId: traverseList(item, 'browseId').at(-1),
            playlistId: traverseString(item, 'thumbnailOverlay', 'playlistId'),
            name: traverseString(item, 'title', 'text'),
            artist: artistBasic,
            year: AlbumParser.processYear(traverseList(item, 'subtitle', 'text').at(-1)),
            thumbnails: traverseList(item, 'thumbnails'),
        }, AlbumDetailed);
    }
    static parseArtistTopAlbum(item, artistBasic) {
        return checkType({
            type: 'ALBUM',
            albumId: traverseList(item, 'browseId').at(-1),
            playlistId: traverseString(item, 'musicPlayButtonRenderer', 'playlistId'),
            name: traverseString(item, 'title', 'text'),
            artist: artistBasic,
            year: AlbumParser.processYear(traverseList(item, 'subtitle', 'text').at(-1)),
            thumbnails: traverseList(item, 'thumbnails'),
        }, AlbumDetailed);
    }
    static processYear(year) {
        return year && year.match(/^\d{4}$/) ? +year : null;
    }
}
//# sourceMappingURL=album_parser.js.map