import { VideoDetailed, } from '#services/YoutubeAPI/@types/types';
import checkType from '#services/YoutubeAPI/utils/check_type';
import { isAlbum, isArtist, isDuration, isTitle, isViewCount, } from '#services/YoutubeAPI/utils/filters';
import { traverse, traverseList, traverseString } from '#services/YoutubeAPI/utils/traverse';
import Parser from '#services/YoutubeAPI/parsers/parser';
export default class VideoParser {
    static parse(data) {
        return {
            type: 'VIDEO',
            videoId: traverseString(data, 'videoDetails', 'videoId'),
            name: traverseString(data, 'videoDetails', 'title'),
            artist: {
                artistId: traverseString(data, 'videoDetails', 'channelId'),
                name: traverseString(data, 'author'),
            },
            duration: +traverseString(data, 'videoDetails', 'lengthSeconds'),
            views: traverseString(data, 'viewCount'),
            thumbnails: traverseList(data, 'videoDetails', 'thumbnails'),
            unlisted: traverse(data, 'unlisted'),
            familySafe: traverse(data, 'familySafe'),
            paid: traverse(data, 'paid'),
            tags: traverseList(data, 'tags'),
        };
    }
    static parseSearchResult(item) {
        const columns = traverseList(item, 'flexColumns', 'runs').flat();
        const title = columns.find(isTitle);
        const artist = columns.find(isArtist) || columns[1];
        const duration = columns.find(isDuration);
        return {
            type: 'VIDEO',
            videoId: traverseString(item, 'playNavigationEndpoint', 'videoId'),
            name: traverseString(title, 'text'),
            artist: {
                artistId: traverseString(artist, 'browseId') || null,
                name: traverseString(artist, 'text'),
            },
            duration: Parser.parseDuration(duration.text),
            thumbnails: traverseList(item, 'thumbnails'),
            views: 'd;d',
        };
    }
    static parseArtistTopVideo(item, artistBasic) {
        const subtitleColumns = traverseList(item, 'subtitle', 'runs').flat();
        const totalViews = subtitleColumns.find(isViewCount);
        return {
            type: 'VIDEO',
            videoId: traverseString(item, 'videoId'),
            name: traverseString(item, 'runs', 'text'),
            artist: artistBasic,
            duration: null,
            views: totalViews ? traverseString(totalViews, 'text') : null,
            thumbnails: traverseList(item, 'thumbnails'),
        };
    }
    static parseVideoForChart(item) {
        const columns = traverseList(item, 'flexColumns', 'runs').flat();
        const title = columns.filter(isTitle);
        let artistList = [];
        if (columns.length > 1) {
            artistList = columns
                .filter((columnItem, index) => index > 0 && !columnItem.text.includes('views') && !columnItem.text.includes('•'))
                .map((columnItem) => {
                console.log(columnItem);
                const artist = [columnItem].filter(isArtist);
                const album = [columnItem].filter(isAlbum);
                return {
                    artistId: traverseString(artist, 'browseId') || null,
                    albumId: traverseString(album, 'browseId') || null,
                    name: traverseString(columnItem, 'text'),
                };
            });
        }
        return {
            type: 'VIDEO',
            videoId: traverseString(item, 'videoId'),
            name: title.length ? traverseString(title, 'text') : traverseString(columns[0], 'text'),
            artist: artistList,
            duration: null,
            thumbnails: traverseList(item, 'thumbnails'),
        };
    }
    static parsePlaylistVideo(item) {
        const columns = traverseList(item, 'flexColumns', 'runs').flat();
        const menu = traverseList(item, 'menu', 'items');
        const artistIds = menu.find(isArtist);
        const title = columns.find(isTitle) || columns[0];
        const artist = columns.find(isArtist) || columns[1];
        const duration = columns.find(isDuration);
        const totalViews = columns.find(isViewCount);
        return checkType({
            type: 'VIDEO',
            videoId: traverseString(item, 'playNavigationEndpoint', 'videoId') ||
                traverseString(item, 'videoId') ||
                traverseList(item, 'thumbnails')[0].url.match(/https:\/\/i\.ytimg\.com\/vi\/(.+)\//)[1],
            name: traverseString(title, 'text'),
            artist: {
                name: traverseString(artist, 'text'),
                artistId: traverseString(artistIds, 'browseId') || null,
            },
            views: totalViews ? traverseString(totalViews, 'text') : null,
            duration: duration ? Parser.parseDuration(duration.text) : null,
            thumbnails: traverseList(item, 'thumbnails'),
        }, VideoDetailed);
    }
}
//# sourceMappingURL=video_parser.js.map