import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'kloud_operators';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('operator_id').primary();
            table.string('fullname').notNullable();
            table.string('phone', 225).notNullable();
            table.string('email', 225).notNullable();
            table.string('password', 225).notNullable();
            table.integer('permission_level').notNullable();
            table.integer('account_status').notNullable();
            table.string('member_token', 225);
            table.dateTime('last_login');
            table.dateTime('last_seen');
            table.timestamp('created_at', { useTz: true });
            table.timestamp('updated_at', { useTz: true });
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1706439865512_create_kloud_operators_table.js.map