import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'kloud_playlist_libraries';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('playlist_library_id').primary().notNullable();
            table
                .uuid('user_id')
                .notNullable()
                .unsigned()
                .references('user_id')
                .inTable('kloud_users')
                .onDelete('CASCADE');
            table.string('playlist_name').notNullable();
            table.integer('total_items').defaultTo(0);
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1707149058794_create_kloud_playlist_libraries_table.js.map