import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'subscription_history';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('subscription_id').primary().notNullable();
            table.uuid('subscriber_user_id').notNullable();
            table.uuid('sub_plan_id').notNullable();
            table.uuid('subscriber_token').notNullable();
            table.string('subscription_channel').notNullable();
            table.integer('subscription_status').defaultTo(0);
            table.timestamp('subscription_expire_at').notNullable();
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1717842872745_create_subscription_history_table.js.map