import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'subscription_tokens';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('subscription_token_id').primary().notNullable();
            table.uuid('user_id').notNullable();
            table.string('glassfy_subcriber_id').defaultTo('');
            table.string('flutterwave_plan_id').defaultTo('');
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1717880688984_create_subscription_tokens_table.js.map