var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import { inject } from '@adonisjs/core';
import ApiResponseService from '#services/api_response_service';
import YoutubeApiService from '#services/YoutubeAPI/index_service';
let HomepagesController = class HomepagesController {
    apiResponseService;
    ytmusic;
    constructor(apiResponseService, ytmusic) {
        this.apiResponseService = apiResponseService;
        this.ytmusic = ytmusic;
    }
    async getHomePageContent() {
        try {
            await this.ytmusic.initialize();
            const homepageContent = await this.ytmusic.getHome();
            return this.apiResponseService.apiSuccessResponse(homepageContent, 'Success');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/SearchByGenresController/getAllGenres');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(500, 'Server Error');
        }
    }
};
HomepagesController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService,
        YoutubeApiService])
], HomepagesController);
export default HomepagesController;
//# sourceMappingURL=homepages_controller.js.map