var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import Country from '#models/country';
import KloudAppSetting from '#models/kloud_app_setting';
import YoutubeApiService from '#services/YoutubeAPI/index_service';
import ApiResponseService from '#services/api_response_service';
import { inject } from '@adonisjs/core';
let MiscsController = class MiscsController {
    apiResponseService;
    ytmusic;
    constructor(apiResponseService, ytmusic) {
        this.apiResponseService = apiResponseService;
        this.ytmusic = ytmusic;
    }
    async fetchAllCountries() {
        try {
            const countriesList = await Country.query().orderBy('id', 'asc');
            return this.apiResponseService.apiSuccessResponse(countriesList, 'Countries fetched successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/MiscsController/fetchAllCountries');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(500, 'Server Error');
        }
    }
    async fetchAppSetting() {
        try {
            const settingList = await KloudAppSetting.query().orderBy('setting_key', 'asc');
            return this.apiResponseService.apiSuccessResponse(settingList, 'Setting fetched successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/MiscsController/fetchAppSetting');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(500, 'Server Error');
        }
    }
    async fetchArtistList() {
        try {
            await this.ytmusic.initialize();
            const genreList = await this.ytmusic.getArtistList();
            return this.apiResponseService.apiSuccessResponse(genreList, genreList.length ? 'Success' : 'No genres found for your country');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/MiscsController/fetchArtistList');
            return this.apiResponseService.apiErrorResponse(500, 'Server Error');
        }
    }
};
MiscsController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService,
        YoutubeApiService])
], MiscsController);
export default MiscsController;
//# sourceMappingURL=miscs_controller.js.map