var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import KloudArtist from '#models/kloud_artist';
import KloudArtistLibrary from '#models/kloud_artist_library';
import ApiResponseService from '#services/api_response_service';
import { convertStringToNumeric } from '#utils/index';
import { followArtistRequestParams } from '#validators/user_library';
import { inject } from '@adonisjs/core';
import db from '@adonisjs/lucid/services/db';
import { validate as uuidValidate } from 'uuid';
let UserFollowArtistsController = class UserFollowArtistsController {
    apiResponseService;
    constructor(apiResponseService) {
        this.apiResponseService = apiResponseService;
    }
    async fetchFollowedArtist({ auth }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const allUserFollowedArtist = await KloudArtist.query()
                .whereHas('artistLibrary', (library) => {
                library.where('user_id', userToken.id);
            })
                .preload('artistLibrary');
            return this.apiResponseService.apiSuccessResponse(allUserFollowedArtist, 'Playlist loaded successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserFollowArtistsController/fetchFollowedArtist');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async followArtist({ request, auth }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const payload = await followArtistRequestParams.validate(request.all());
            await db.transaction(async (trx) => {
                try {
                    const totalFollowers = convertStringToNumeric(payload.follower);
                    const doArtistExist = await KloudArtist.findBy('yt_artist_id', payload.artistId);
                    if (doArtistExist) {
                        const isUserFollowingArtist = await KloudArtistLibrary.query()
                            .where('user_id', userToken.id)
                            .where('artist_id', doArtistExist.id)
                            .first();
                        if (isUserFollowingArtist) {
                            return this.apiResponseService.apiSuccessResponse('', 'Already followed');
                        }
                        const newFollow = new KloudArtistLibrary();
                        newFollow.user_id = userToken.id;
                        newFollow.kloudArtistId = doArtistExist.id;
                        newFollow.useTransaction(trx);
                        await newFollow.save();
                        doArtistExist.artist_followers_count = doArtistExist.artist_followers_count + 1;
                        doArtistExist.useTransaction(trx);
                        doArtistExist.save();
                        trx.commit();
                        return this.apiResponseService.apiSuccessResponse('', 'Followed now');
                    }
                    else {
                        const newArtist = new KloudArtist();
                        newArtist.yt_artist_id = payload.artistId;
                        newArtist.artist_name = payload.name;
                        newArtist.artist_followers = payload.follower;
                        newArtist.artist_followers_count = totalFollowers + 1;
                        newArtist.full_detailed = true;
                        newArtist.thumbnail = JSON.stringify(request.input('thumbnails'));
                        newArtist.useTransaction(trx);
                        const newArtistStored = await newArtist.save();
                        const newFollow = new KloudArtistLibrary();
                        newFollow.user_id = userToken.id;
                        newFollow.kloudArtistId = newArtistStored.id;
                        newFollow.useTransaction(trx);
                        await newFollow.save();
                        trx.commit();
                        return this.apiResponseService.apiSuccessResponse('', 'Followed now');
                    }
                }
                catch (error) {
                    trx.rollback();
                    throw Error(error);
                }
            });
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserFollowArtistsController/followArtist');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async unfollowArtist({ params, auth }) {
        try {
            if (uuidValidate(params.artistId) === false) {
                return this.apiResponseService.apiErrorResponse(400, 'Artist Id is required');
            }
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            await db.transaction(async (trx) => {
                try {
                    const doArtistExist = await KloudArtist.findBy('id', params.artistId);
                    if (!doArtistExist) {
                        return this.apiResponseService.apiSuccessResponse('', 'Artist Id is required');
                    }
                    const isUserFollowingArtist = await KloudArtistLibrary.query()
                        .where('user_id', userToken.id)
                        .where('artist_id', params.artistId)
                        .first();
                    if (!isUserFollowingArtist) {
                        return this.apiResponseService.apiSuccessResponse('', 'Artist Id is required');
                    }
                    isUserFollowingArtist.useTransaction(trx);
                    await isUserFollowingArtist.delete();
                    doArtistExist.artist_followers_count = doArtistExist.artist_followers_count + 1;
                    doArtistExist.useTransaction(trx);
                    await doArtistExist.save();
                    trx.commit();
                    return this.apiResponseService.apiSuccessResponse('', 'Unfollowed artist');
                }
                catch (error) {
                    trx.rollback();
                    throw Error(error);
                }
            });
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserFollowArtistsController/unfollowArtist');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
};
UserFollowArtistsController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService])
], UserFollowArtistsController);
export default UserFollowArtistsController;
//# sourceMappingURL=user_follow_artists_controller.js.map