import { type, union } from 'arktype';
export const ThumbnailFull = type({
    url: 'string',
    width: 'number',
    height: 'number',
});
export const Genre = type({
    title: 'string',
    paramId: 'string',
    color: 'string',
});
export const ArtistBasic = type({
    'artistId': 'string|null',
    'albumId?': 'string|null',
    'name': 'string',
});
export const AlbumBasic = type({
    albumId: 'string',
    name: 'string',
});
export const SongDetailed = type({
    type: '"SONG"',
    videoId: 'string',
    name: 'string',
    artist: ArtistBasic,
    album: union(AlbumBasic, 'null'),
    duration: 'number|null',
    thumbnails: [ThumbnailFull, '[]'],
    views: 'string|undefined',
});
export const VideoDetailed = type({
    type: '"VIDEO"',
    videoId: 'string',
    name: 'string',
    artist: ArtistBasic,
    duration: 'number|null',
    thumbnails: [ThumbnailFull, '[]'],
    views: 'string|null',
});
export const VideoDetailedModified = type({
    type: '"VIDEO"',
    videoId: 'string',
    name: 'string',
    artist: [ArtistBasic, '[]'],
    duration: 'number|null',
    thumbnails: [ThumbnailFull, '[]'],
});
export const ArtistDetailed = type({
    artistId: 'string',
    name: 'string',
    follower: 'string|null',
    type: '"ARTIST"',
    thumbnails: [ThumbnailFull, '[]'],
});
export const AlbumDetailed = type({
    type: '"ALBUM"',
    albumId: 'string',
    playlistId: 'string',
    name: 'string',
    artist: ArtistBasic,
    year: 'number|null',
    thumbnails: [ThumbnailFull, '[]'],
});
export const PlaylistDetailed = type({
    type: '"PLAYLIST"',
    playlistId: 'string',
    name: 'string',
    artist: ArtistBasic,
    thumbnails: [ThumbnailFull, '[]'],
});
export const SongFull = type({
    type: '"SONG"',
    videoId: 'string',
    name: 'string',
    artist: ArtistBasic,
    duration: 'number',
    thumbnails: [ThumbnailFull, '[]'],
    formats: 'any[]',
    adaptiveFormats: 'any[]',
    views: 'string|undefined',
});
export const VideoFull = type({
    type: '"VIDEO"',
    videoId: 'string',
    name: 'string',
    artist: ArtistBasic,
    duration: 'number',
    thumbnails: [ThumbnailFull, '[]'],
    unlisted: 'boolean',
    familySafe: 'boolean',
    paid: 'boolean',
    tags: 'string[]',
    views: 'string|undefined',
});
export const ArtistFull = type({
    artistId: 'string',
    name: 'string',
    type: '"ARTIST"',
    thumbnails: [ThumbnailFull, '[]'],
    topSongs: [SongDetailed, '[]'],
    topAlbums: [AlbumDetailed, '[]'],
    topSingles: [AlbumDetailed, '[]'],
    topVideos: [VideoDetailed, '[]'],
    featuredOn: [PlaylistDetailed, '[]'],
    similarArtists: [ArtistDetailed, '[]'],
    follower: 'string|null',
});
export const AlbumFull = type({
    type: '"ALBUM"',
    albumId: 'string',
    playlistId: 'string',
    name: 'string',
    artist: ArtistBasic,
    year: 'number|null',
    thumbnails: [ThumbnailFull, '[]'],
    songs: [SongDetailed, '[]'],
});
export const PlaylistFull = type({
    type: '"PLAYLIST"',
    playlistId: 'string',
    name: 'string',
    artist: ArtistBasic,
    videoCount: 'number',
    totalDuration: 'string',
    thumbnails: [ThumbnailFull, '[]'],
});
export const SearchResult = union(SongDetailed, union(VideoDetailed, union(AlbumDetailed, union(ArtistDetailed, PlaylistDetailed))));
export const PlaylistWatch = type({
    type: '"PLAYLIST"',
    playlistId: 'string',
    name: 'string',
    thumbnails: [ThumbnailFull, '[]'],
});
export const HomePageContent = type({
    title: 'string',
    contents: [
        union(PlaylistWatch, union(ArtistDetailed, union(AlbumDetailed, union(PlaylistDetailed, SongDetailed)))),
        '[]',
    ],
});
export const ChartResult = union(SongDetailed, union(VideoDetailed, union(AlbumDetailed, union(ArtistDetailed, union(VideoDetailedModified, union(PlaylistDetailed, PlaylistWatch))))));
export const Chart = type({
    title: 'string',
    items: [ChartResult, '[]'],
});
//# sourceMappingURL=types.js.map