var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { HttpContext } from '@adonisjs/core/http';
import { inject } from '@adonisjs/core';
import axios from 'axios';
import { Cookie, CookieJar } from 'tough-cookie';
import { FE_CHARTS, FE_GENRES, FE_GENRES_CATEGORY, FE_MUSIC_HOME, FE_MUSIC_TASTEBUILDER, } from '#services/YoutubeAPI/constants';
import { traverse, traverseList, traverseString } from '#services/YoutubeAPI/utils/traverse';
import ArtistParser from '#services/YoutubeAPI/parsers/artist_parser';
import SearchParser from '#services/YoutubeAPI/parsers/search_parser';
import SongParser from '#services/YoutubeAPI/parsers/song_parser';
import VideoParser from '#services/YoutubeAPI/parsers/video_parser';
import PlaylistParser from '#services/YoutubeAPI/parsers/playlist_parser';
import Parser from '#services/YoutubeAPI/parsers/parser';
import AlbumParser from '#services/YoutubeAPI/parsers/album_parser';
import GenreParser from '#services/YoutubeAPI/parsers/genre_parser';
import ChartParser from './parsers/chart_parser.js';
let YoutubeApiService = class YoutubeApiService {
    ctx;
    userAgent = 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36';
    cookiejar;
    config;
    client;
    constructor(ctx) {
        this.ctx = ctx;
        this.cookiejar = new CookieJar();
        this.config = {};
        this.client = axios.create({
            baseURL: 'https://music.youtube.com/',
            headers: {
                'User-Agent': this.userAgent,
                'Accept-Language': 'en-US,en;q=0.5',
            },
            withCredentials: true,
        });
        this.client.interceptors.request.use((req) => {
            if (!req.baseURL)
                return req;
            const cookieString = this.cookiejar.getCookieStringSync(req.baseURL);
            if (cookieString) {
                if (!req.headers) {
                    req.headers = req.headers || {};
                }
                req.headers['Cookie'] = cookieString;
            }
            return req;
        });
        this.client.interceptors.response.use((res) => {
            if ('set-cookie' in res.headers) {
                if (!res.config.baseURL)
                    return res;
                const setCookie = res.headers['set-cookie'];
                for (const cookieString of [setCookie].flat()) {
                    const cookie = Cookie.parse(`${cookieString}`);
                    if (!cookie)
                        return res;
                    this.cookiejar.setCookieSync(cookie, res.config.baseURL);
                }
            }
            return res;
        });
    }
    async initialize(options) {
        const { cookies, GL, HL } = options ?? {};
        if (cookies) {
            for (const cookieString of cookies.split('; ')) {
                const cookie = Cookie.parse(`${cookieString}`);
                if (!cookie)
                    return;
                this.cookiejar.setCookieSync(cookie, 'https://music.youtube.com/');
            }
        }
        const clientRequest = await this.client.get('/');
        const html = clientRequest.data;
        const setConfigs = RegExp(/ytcfg\.set\(.*\)/).exec(html) ?? [];
        const configs = setConfigs
            .map((c) => c.slice(10, -1))
            .map((s) => {
            try {
                return JSON.parse(s);
            }
            catch {
                return null;
            }
        })
            .filter((j) => !!j);
        for (const config of configs) {
            this.config = {
                ...this.config,
                ...config,
            };
        }
        if (!this.config) {
            this.config = {};
        }
        if (GL)
            this.config.GL = GL;
        if (HL)
            this.config.HL = HL;
        return this;
    }
    async constructRequest(endpoint, body = {}, query = {}) {
        if (!this.config) {
            throw new Error('API not initialized. Make sure to call the initialize() method first');
        }
        const headers = {
            ...this.client.defaults.headers,
            'x-origin': this.client.defaults.baseURL,
            'X-Goog-Visitor-Id': this.config.VISITOR_DATA || '',
            'X-YouTube-Client-Name': this.config.INNERTUBE_CONTEXT_CLIENT_NAME,
            'X-YouTube-Client-Version': this.config.INNERTUBE_CLIENT_VERSION,
            'X-YouTube-Device': this.config.DEVICE,
            'X-YouTube-Page-CL': this.config.PAGE_CL,
            'X-YouTube-Page-Label': this.config.PAGE_BUILD_LABEL,
            'X-YouTube-Utc-Offset': String(-new Date().getTimezoneOffset()),
            'X-YouTube-Time-Zone': new Intl.DateTimeFormat().resolvedOptions().timeZone,
        };
        const searchParams = new URLSearchParams({
            ...query,
            alt: 'json',
            key: this.config.INNERTUBE_API_KEY,
        });
        const res = await this.client.post(`youtubei/${this.config.INNERTUBE_API_VERSION}/${endpoint}?${searchParams.toString()}`, {
            context: {
                capabilities: {},
                client: {
                    clientName: this.config.INNERTUBE_CLIENT_NAME,
                    clientVersion: this.config.INNERTUBE_CLIENT_VERSION,
                    experimentIds: [],
                    experimentsToken: '',
                    gl: this.config.GL,
                    hl: this.config.HL,
                    locationInfo: {
                        locationPermissionAuthorizationStatus: 'LOCATION_PERMISSION_AUTHORIZATION_STATUS_UNSUPPORTED',
                    },
                    musicAppInfo: {
                        musicActivityMasterSwitch: 'MUSIC_ACTIVITY_MASTER_SWITCH_INDETERMINATE',
                        musicLocationMasterSwitch: 'MUSIC_LOCATION_MASTER_SWITCH_INDETERMINATE',
                        pwaInstallabilityStatus: 'PWA_INSTALLABILITY_STATUS_UNKNOWN',
                    },
                    utcOffsetMinutes: 120,
                },
                request: {
                    internalExperimentFlags: [
                        {
                            key: 'force_music_enable_outertube_tastebuilder_browse',
                            value: 'true',
                        },
                        {
                            key: 'force_music_enable_outertube_playlist_detail_browse',
                            value: 'true',
                        },
                        {
                            key: 'force_music_enable_outertube_search_suggestions',
                            value: 'true',
                        },
                    ],
                    sessionIndex: {},
                },
                user: {
                    enableSafetyMode: false,
                },
            },
            ...body,
        }, {
            responseType: 'json',
            headers,
        });
        return 'responseContext' in res.data ? res.data : res;
    }
    async getHome() {
        const results = [];
        const page = await this.constructRequest('browse', { browseId: FE_MUSIC_HOME });
        traverseList(page, 'sectionListRenderer', 'contents').forEach((content) => {
            const parsed = Parser.parseMixedContent(content);
            parsed && results.push(parsed);
        });
        let continuation = traverseString(page, 'continuation');
        while (continuation) {
            const nextPage = await this.constructRequest('browse', {}, { continuation });
            traverseList(nextPage, 'sectionListContinuation', 'contents').forEach((content) => {
                const parsed = Parser.parseMixedContent(content);
                parsed && results.push(parsed);
            });
            continuation = traverseString(nextPage, 'continuation');
        }
        return results;
    }
    async getArtistList() {
        const results = [];
        const page = await this.constructRequest('browse', { browseId: FE_MUSIC_TASTEBUILDER });
        traverseList(page, 'tastebuilderRenderer', 'contents').forEach((content) => {
            traverseList(content, 'tastebuilderItemListRenderer', 'contents').forEach((artistItem) => {
                results.push(artistItem);
            });
        });
        return results;
    }
    async getGenres() {
        const results = [];
        const page = await this.constructRequest('browse', { browseId: FE_GENRES });
        traverseList(page, 'sectionListRenderer', 'contents').forEach((content) => {
            traverseList(content, 'gridRenderer', 'items').forEach((genreItem) => {
                const parsed = GenreParser.parse(genreItem);
                parsed &&
                    results.findIndex((item) => item.paramId === parsed.paramId) === -1 &&
                    results.push(parsed);
            });
        });
        results.sort((a, b) => {
            const titleA = a.title.toLowerCase();
            const titleB = b.title.toLowerCase();
            if (titleA < titleB) {
                return -1;
            }
            else if (titleA > titleB) {
                return 1;
            }
            else {
                return 0;
            }
        });
        return results;
    }
    async getGenresItems(paramId) {
        const results = [];
        const page = await this.constructRequest('browse', {
            browseId: FE_GENRES_CATEGORY,
            params: paramId,
        });
        traverseList(page, 'sectionListRenderer', 'contents').forEach((content) => {
            const parsed = Parser.parseMixedContent(content);
            parsed && results.push(parsed);
        });
        return results;
    }
    async getChart(countryFilterCode) {
        const results = [];
        const page = await this.constructRequest('browse', {
            browseId: FE_CHARTS,
            params: 'sgYPRkVtdXNpY19leHBsb3Jl',
        });
        traverseList(page, 'sectionListRenderer', 'contents').forEach((content) => {
            if (content.musicCarouselShelfRenderer) {
                const title = traverse(content, 'musicCarouselShelfRenderer', 'header', 'musicCarouselShelfBasicHeaderRenderer', 'title', 'runs', 'text');
                console.log(title);
                const sectionContent = [];
                traverseList(content, 'musicCarouselShelfRenderer', 'contents').forEach((item) => {
                    const parsed = ChartParser.parseChartList(item);
                    parsed && sectionContent.push(parsed[0]);
                });
                results.push({ title, items: sectionContent });
            }
        });
        return results;
    }
    async getSearchSuggestions(query) {
        return traverseList(await this.constructRequest('music/get_search_suggestions', {
            input: query,
        }), 'query');
    }
    async search(query) {
        const searchData = await this.constructRequest('search', {
            query,
            params: null,
        });
        return traverseList(searchData, 'musicResponsiveListItemRenderer')
            .map(SearchParser.parse)
            .filter(Boolean);
    }
    async searchSongs(query) {
        const searchData = await this.constructRequest('search', {
            query,
            params: 'Eg-KAQwIARAAGAAgACgAMABqChAEEAMQCRAFEAo%3D',
        });
        return traverseList(searchData, 'musicResponsiveListItemRenderer').map(SongParser.parseSearchResult);
    }
    async searchVideos(query) {
        const searchData = await this.constructRequest('search', {
            query,
            params: 'Eg-KAQwIABABGAAgACgAMABqChAEEAMQCRAFEAo%3D',
        });
        return traverseList(searchData, 'musicResponsiveListItemRenderer').map(VideoParser.parseSearchResult);
    }
    async searchArtists(query) {
        const searchData = await this.constructRequest('search', {
            query,
            params: 'Eg-KAQwIABAAGAAgASgAMABqChAEEAMQCRAFEAo%3D',
        });
        return traverseList(searchData, 'musicResponsiveListItemRenderer').map(ArtistParser.parseSearchResult);
    }
    async searchAlbums(query) {
        const searchData = await this.constructRequest('search', {
            query,
            params: 'Eg-KAQwIABAAGAEgACgAMABqChAEEAMQCRAFEAo%3D',
        });
        return traverseList(searchData, 'musicResponsiveListItemRenderer').map(AlbumParser.parseSearchResult);
    }
    async searchPlaylists(query) {
        const searchData = await this.constructRequest('search', {
            query,
            params: 'Eg-KAQwIABAAGAAgACgBMABqChAEEAMQCRAFEAo%3D',
        });
        return traverseList(searchData, 'musicResponsiveListItemRenderer').map(PlaylistParser.parseSearchResult);
    }
    async getSong(videoId) {
        if (!RegExp(/^[a-zA-Z0-9-_]{11}$/).exec(videoId))
            throw new Error('Invalid videoId');
        const data = await this.constructRequest('player', { videoId });
        const song = SongParser.parse(data);
        if (song.videoId !== videoId)
            throw new Error('Invalid videoId');
        return song;
    }
    async getVideo(videoId) {
        if (!RegExp(/^[a-zA-Z0-9-_]{11}$/).exec(videoId))
            throw new Error('Invalid videoId');
        const data = await this.constructRequest('player', { videoId });
        const video = VideoParser.parse(data);
        if (video.videoId !== videoId)
            throw new Error('Invalid videoId');
        return video;
    }
    async getLyrics(videoId) {
        if (!RegExp(/^[a-zA-Z0-9-_]{11}$/).exec(videoId))
            throw new Error('Invalid videoId');
        const data = await this.constructRequest('next', { videoId });
        const browseId = traverse(traverseList(data, 'tabs', 'tabRenderer')[1], 'browseId');
        const lyricsData = await this.constructRequest('browse', { browseId });
        const lyrics = traverseString(lyricsData, 'description', 'runs', 'text');
        return lyrics
            ? lyrics
                .replaceAll('\r', '')
                .split('\n')
                .filter((v) => !!v)
            : null;
    }
    async getArtist(artistId) {
        const data = await this.constructRequest('browse', {
            browseId: artistId,
        });
        return ArtistParser.parse(data, artistId);
    }
    async getArtistSongs(artistId) {
        const artistData = await this.constructRequest('browse', { browseId: artistId });
        const browseToken = traverse(artistData, 'musicShelfRenderer', 'title', 'browseId');
        if (Array.isArray(browseToken))
            return [];
        const songsData = await this.constructRequest('browse', { browseId: browseToken });
        const continueToken = traverse(songsData, 'continuation');
        const moreSongsData = await this.constructRequest('browse', {}, { continuation: continueToken });
        return [
            ...traverseList(songsData, 'musicResponsiveListItemRenderer'),
            ...traverseList(moreSongsData, 'musicResponsiveListItemRenderer'),
        ].map((s) => SongParser.parseArtistSong(s, {
            artistId,
            name: traverseString(artistData, 'header', 'title', 'text'),
        }));
    }
    async getArtistAlbums(artistId) {
        const artistData = await this.constructRequest('browse', {
            browseId: artistId,
        });
        const artistAlbumsData = traverseList(artistData, 'musicCarouselShelfRenderer')[0];
        const browseBody = traverse(artistAlbumsData, 'moreContentButton', 'browseEndpoint');
        const albumsData = await this.constructRequest('browse', browseBody);
        return traverseList(albumsData, 'musicTwoRowItemRenderer').map((item) => AlbumParser.parseArtistAlbum(item, {
            artistId,
            name: traverseString(albumsData, 'header', 'runs', 'text'),
        }));
    }
    async getAlbum(albumId) {
        const data = await this.constructRequest('browse', {
            browseId: albumId,
        });
        return AlbumParser.parse(data, albumId);
    }
    async getPlaylist(playlistId) {
        if (playlistId.startsWith('PL'))
            playlistId = 'VL' + playlistId;
        const data = await this.constructRequest('browse', {
            browseId: playlistId,
        });
        return PlaylistParser.parse(data, playlistId);
    }
    async getPlaylistVideos(playlistId) {
        if (playlistId.startsWith('PL'))
            playlistId = 'VL' + playlistId;
        const playlistData = await this.constructRequest('browse', {
            browseId: playlistId,
        });
        const songs = traverseList(playlistData, 'musicPlaylistShelfRenderer', 'musicResponsiveListItemRenderer');
        let continuation = traverse(playlistData, 'continuation');
        while (!Array.isArray(continuation)) {
            const songsData = await this.constructRequest('browse', {}, { continuation });
            songs.push(...traverseList(songsData, 'musicResponsiveListItemRenderer'));
            continuation = traverse(songsData, 'continuation');
        }
        return songs.map(VideoParser.parsePlaylistVideo);
    }
};
YoutubeApiService = __decorate([
    inject(),
    __metadata("design:paramtypes", [HttpContext])
], YoutubeApiService);
export default YoutubeApiService;
//# sourceMappingURL=index_service.js.map