import vine from '@vinejs/vine';
export const followArtistRequestParams = vine.compile(vine.object({
    artistId: vine.string().trim().escape(),
    name: vine.string().trim().escape(),
    follower: vine.string().trim().escape(),
    thumbnails: vine.array(vine.object({
        url: vine.string().trim().escape(),
        width: vine.number(),
        height: vine.number(),
    })),
}));
export const createNewPlaylistRequestParams = vine.compile(vine.object({
    playlist_name: vine.string().trim().escape(),
}));
export const editPlaylistNameRequestParams = vine.compile(vine.object({
    playlist_id: vine.string().trim().escape().uuid(),
    playlist_name: vine.string().trim().escape(),
}));
export const addSongToPlaylistRequestParams = vine.compile(vine.object({
    playlist_id: vine.string().trim().escape().uuid(),
    song_id: vine.string().trim().escape(),
    song_name: vine.string().trim().escape(),
    artist: vine.object({
        name: vine.string().trim().escape(),
        artistId: vine.string().trim().escape(),
    }),
    thumbnails: vine.array(vine.object({
        url: vine.string().trim().escape(),
        width: vine.number(),
        height: vine.number(),
    })),
}));
export const addNewAlbumRequestParams = vine.compile(vine.object({
    albumId: vine.string().trim().escape(),
    name: vine.string().trim().escape(),
    artist: vine.object({
        name: vine.string().trim().escape(),
        artistId: vine.string().trim().escape(),
    }),
    thumbnails: vine.array(vine.object({
        url: vine.string().trim().escape(),
        width: vine.number(),
        height: vine.number(),
    })),
}));
export const addItemToFavouriteRequestParams = vine.compile(vine.object({
    item_id: vine.string().trim().escape(),
    item_name: vine.string().trim().escape(),
    artist: vine.object({
        name: vine.string().trim().escape(),
        artistId: vine.string().trim().escape(),
    }),
    thumbnails: vine.array(vine.object({
        url: vine.string().trim().escape(),
        width: vine.number(),
        height: vine.number(),
    })),
    item_type: vine.enum(['song', 'album', 'playlist']),
}));
//# sourceMappingURL=user_library.js.map