import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'kloud_users';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('user_id').primary().notNullable();
            table.string('first_name', 225).notNullable();
            table.string('last_name', 225).notNullable();
            table.string('username', 225).notNullable();
            table.string('kloud_password', 225).notNullable();
            table.string('avatar', 225).notNullable().defaultTo('default.jpg');
            table.string('language', 225).notNullable().defaultTo('EN');
            table.string('country', 225).notNullable().defaultTo('');
            table.string('country_code', 225).notNullable().defaultTo('');
            table.string('address', 225).notNullable().defaultTo('');
            table.string('city', 225).notNullable().defaultTo('');
            table.string('state', 225).notNullable().defaultTo('');
            table.string('zip_code', 225).notNullable().defaultTo('');
            table.string('address2', 225).notNullable().defaultTo('');
            table.string('gender', 225).notNullable().defaultTo('Male');
            table.dateTime('date_of_birth').notNullable().defaultTo('2022-01-01 00:00:00');
            table.string('phone', 225).notNullable().defaultTo('070xxxxxxx');
            table.string('email', 225).notNullable();
            table.string('auth_type', 20).notNullable();
            table.integer('account_status').notNullable();
            table.timestamp('created_at', { useTz: true });
            table.timestamp('updated_at', { useTz: true });
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1706439708399_create_kloud_users_table.js.map