import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'kloud_user_settings';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('user_setting_id').primary().notNullable();
            table
                .uuid('app_setting_id')
                .notNullable()
                .unsigned()
                .references('app_setting_id')
                .inTable('kloud_app_settings')
                .onDelete('CASCADE');
            table
                .uuid('user_id')
                .notNullable()
                .unsigned()
                .references('user_id')
                .inTable('kloud_users')
                .onDelete('CASCADE');
            table.jsonb('setting_value').defaultTo({});
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1707059245740_create_kloud_user_settings_table.js.map