import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'kloud_album_libraries';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('library_id').primary().notNullable();
            table
                .uuid('user_id')
                .notNullable()
                .unsigned()
                .references('user_id')
                .inTable('kloud_users')
                .onDelete('CASCADE');
            table.string('album_id').notNullable();
            table.string('album_name').notNullable();
            table.jsonb('artist').notNullable().defaultTo({});
            table.jsonb('thumbnail').notNullable().defaultTo([]);
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1707149121187_create_kloud_album_libraries_table.js.map