import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'kloud_favourite_item';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('favourite_id').primary().notNullable();
            table
                .uuid('user_id')
                .notNullable()
                .unsigned()
                .references('user_id')
                .inTable('kloud_users')
                .onDelete('CASCADE');
            table.string('item_id').notNullable();
            table.string('item_name').notNullable();
            table.jsonb('artist').notNullable().defaultTo({});
            table.jsonb('thumbnail').notNullable().defaultTo([]);
            table.string('item_type').notNullable();
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1707404441835_create_kloud_favourite_songs_items.js.map