import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'subscription_plans';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('sub_plan_id').primary().notNullable();
            table.string('plan_title').notNullable();
            table.string('plan_slug').notNullable();
            table.double('plan_price', 2).notNullable();
            table.string('plan_category').notNullable();
            table.integer('max_subscribers').defaultTo(1);
            table.boolean('auto_renewal').defaultTo(true);
            table.string('plan_duration').notNullable();
            table.jsonb('plan_extra').defaultTo({});
            table.jsonb('glassfy_detail').defaultTo({});
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1717842804018_create_subscription_palns_table.js.map