import KloudAppSetting from '#models/kloud_app_setting';
import { BaseSeeder } from '@adonisjs/lucid/seeders';
export default class extends BaseSeeder {
    async run() {
        await KloudAppSetting.updateOrCreateMany('setting_key', [
            {
                setting_key: '101',
                name: 'Language',
                description: '',
                slug: 'SETTING_LANGUAGE',
                setting_type: 'SELECT',
                default_value: {
                    value: 'EN',
                },
            },
            {
                setting_key: '102',
                name: 'Country',
                description: '',
                slug: 'SETTING_COUNTRY',
                setting_type: 'SELECT',
                default_value: {
                    value: 'US',
                },
            },
            {
                setting_key: '103',
                name: 'Theme',
                description: '',
                slug: 'SETTING_THEME',
                setting_type: 'SELECT',
                default_value: {
                    value: 'LIGHT',
                },
            },
            {
                setting_key: '104',
                name: 'Timezone',
                description: '',
                slug: 'SETTING_TIMEZONE',
                setting_type: 'SELECT',
                default_value: {
                    value: 'UTC',
                },
            },
            {
                setting_key: '105',
                name: 'Auto Play',
                description: 'Play non stop music. When you are finished with your last track. Kloudaa will start a track radio based on the last track you played.',
                slug: 'SETTING_AUTO_PLAY',
                setting_type: 'SWITCH',
                default_value: {
                    value: false,
                },
            },
            {
                setting_key: '106',
                name: 'Auto Recommend',
                description: 'Improve my song and album recommendation',
                slug: 'SETTING_AUTO_RECOMMEND',
                setting_type: 'SWITCH',
                default_value: {
                    value: false,
                },
            },
            {
                setting_key: '107',
                name: 'Allow Notification',
                description: 'Get push up notification of recent product update, new song/album and music alert recommendation.',
                slug: 'SETTING_ALLOW_NOTIFICATION',
                setting_type: 'SWITCH',
                default_value: {
                    value: false,
                },
            },
            {
                setting_key: '108',
                name: 'Allow In-app Notification',
                description: 'Get pop up notification of recent product update, recaps and recommendation within the app.',
                slug: 'SETTING_ALLOW_INAPP_NOTIFICATION',
                setting_type: 'SWITCH',
                default_value: {
                    value: false,
                },
            },
            {
                setting_key: '109',
                name: 'Lock Screen Thumbnail',
                description: 'Show song and album art thumbnail in lock screen.',
                slug: 'SETTING_LOCK_SCREEN_THUMBNAIL',
                setting_type: 'SWITCH',
                default_value: {
                    value: false,
                },
            },
        ]);
    }
}
//# sourceMappingURL=kloud_app_setting_seeder.js.map