var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import KloudAppSetting from '#models/kloud_app_setting';
import KloudUserSetting from '#models/kloud_user_setting';
import { inject } from '@adonisjs/core';
import { HttpContext } from '@adonisjs/core/http';
let UserServices = class UserServices {
    ctx;
    constructor(ctx) {
        this.ctx = ctx;
    }
    async createUserSettingEntries(userId) {
        try {
            const generateUserSettingList = (settingList) => {
                const userSettings = [];
                for (const setting of settingList) {
                    userSettings.push({
                        kloudAppSettingId: setting.id,
                        user_id: userId,
                        setting_value: setting.default_value,
                    });
                }
                return userSettings;
            };
            const settingList = await KloudAppSetting.query().orderBy('id', 'asc');
            if (settingList) {
                const isCreated = await KloudUserSetting.createMany(generateUserSettingList(settingList));
                if (isCreated) {
                    return true;
                }
            }
        }
        catch (error) {
            throw Error(error);
        }
    }
};
UserServices = __decorate([
    inject(),
    __metadata("design:paramtypes", [HttpContext])
], UserServices);
export default UserServices;
//# sourceMappingURL=index_service.js.map