import { traverseString } from '#services/YoutubeAPI/utils/traverse';
export const isTitle = (data) => {
    return traverseString(data, 'musicVideoType').startsWith('MUSIC_VIDEO_TYPE_');
};
export const isArtist = (data) => {
    return ['MUSIC_PAGE_TYPE_USER_CHANNEL', 'MUSIC_PAGE_TYPE_ARTIST'].includes(traverseString(data, 'pageType'));
};
export const isAlbum = (data) => {
    return traverseString(data, 'pageType') === 'MUSIC_PAGE_TYPE_ALBUM';
};
export const isDuration = (data) => {
    return traverseString(data, 'text').match(/(\d{1,2}:)?\d{1,2}:\d{1,2}/);
};
export const isViewCount = (data) => {
    return (traverseString(data, 'text').endsWith('plays') || traverseString(data, 'text').endsWith('views'));
};
//# sourceMappingURL=filters.js.map